unit [!EcoSpaceUnitName];

interface

uses
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
[!if=(EcoPackageUnitName, "<NONE>")]
  Borland.Eco.Handles;
[!else]
  Borland.Eco.Handles,
  [!EcoPackageUnitName];
[!endif]

type
  [EcoSpace]
[!if=(EcoPackageUnitName, "<NONE>")]
[!else]
  [EcoSpacePackage(TypeOf([!EcoPackageUnitName].[!EcoPackageClassName]))]
[!endif]  
  [!EcoSpaceClassName] = class(Borland.Eco.Handles.DefaultEcoSpace)
  private
    procedure InitializeComponent;
    class var typeSystemProvider: ITypeSystemService;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

implementation

constructor [!EcoSpaceClassName].Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

procedure [!EcoSpaceClassName].InitializeComponent;
begin
end;

class function [!EcoSpaceClassName].GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(typeSystemProvider) then
    typeSystemProvider := MakeTypeService(typeOf(T[!ClassName]));
  Result := typeSystemProvider;
end;

function [!EcoSpaceClassName].GetTypeSystemProvider: ITypeSystemService;
begin
  Result := [!EcoSpaceClassName].GetTypeSystemService;
end;

procedure [!EcoSpaceClassName].UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function [!EcoSpaceClassName].get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function [!EcoSpaceClassName].get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function [!EcoSpaceClassName].get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function [!EcoSpaceClassName].get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function [!EcoSpaceClassName].get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function [!EcoSpaceClassName].get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function [!EcoSpaceClassName].get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

end.
